#include <iostream>
#include <raylib.h>
#include <raymath.h>
#include <stdlib.h>
#include <list>
#include <string.h>
#define NUMTEXTURES 1
int WORLDSCALE = 16;
struct Entity{
    Vector2 pos, vel, acc, size = {0.8,1.8};
    bool istouchingground = 0;
    int chunkdepth;
};
struct Tile{
    unsigned char v, lightness = 0;
};
struct Chunk{
    int depth = -12000; // stores how deep down a chunk is, bigger = deeper
    int replacementdepth = -12000; // used for when the chunk is being replaced with a new chunk
    int id;
    Tile wd[256][16];
};

struct GameInstance{
    Entity *player;
    int playerchunk;
    Vector2 CameraPosition, CameraCenterOffset;
    int WindowWidth, WindowHeight;
    Chunk *world[64] = {nullptr};
    int HighestChunk, LowestChunk;
    std::list<Chunk*> UnloadedChunks;
    std::list<Entity*>Entities;
    Texture2D textures[NUMTEXTURES];
};

struct GlobalTilePosition{unsigned char chunkid, x, y;};
GlobalTilePosition GetTileFromPos(GameInstance* g, Vector2 pos){
    GlobalTilePosition t;
    int chunkdepth = -(((int)pos.y) >> 4);
    t.chunkid = 63 - (g->world[63]->replacementdepth - chunkdepth);
    if(t.chunkid >= 64){
        std::cout << "STOP\n";
    }
    t.x = (int) pos.x;
    t.y = (int) ceil(chunkdepth * 16.0f + pos.y);
    return t;
}

int ChunkPointerComp (const void * a, const void * b) {
   return ( (*(Chunk**)a)->replacementdepth - (*(Chunk**)b)->replacementdepth );
}
void PlayerChangesChunkEvent(GameInstance* g){
    int playerchunkdepth = g->player->chunkdepth;
    if(playerchunkdepth + 8 > g->LowestChunk || playerchunkdepth - 8 < g->HighestChunk){
        if(playerchunkdepth + 8 > g->LowestChunk){ // if more chunks need to be loaded in at the bottom
            for(int i=0;i<8;i++){ // iterating through each chunk to find the ones furthest away
                g->world[i]->replacementdepth = g->LowestChunk + 1;
                if(g->world[i]->depth!= -12000) // if its replacing a chunk thats actually loaded lower the highest chunk by one
                    g->HighestChunk++;
                g->LowestChunk++;
                g->UnloadedChunks.push_back(g->world[i]);
            }
        }

        else if(playerchunkdepth - 8 < g->HighestChunk){ // if more chunks need to be loaded in at the top
            for(int i=63;i>=56;i--){ // iterating through each chunk to find the ones furthest away
                g->world[i]->replacementdepth = g->HighestChunk - 1;
                if(g->world[i]->depth!= -12000) // if its replacing a chunk thats actually loaded raise the lowest chunk by one
                    g->LowestChunk--;
                g->HighestChunk--;
                g->UnloadedChunks.push_back(g->world[i]);
                std::cout << g->world[i]->replacementdepth << " " << g->world[i]->depth << '\n';
            }
        }
        qsort((void*)g->world, 64, sizeof(Chunk*), ChunkPointerComp);
        for(int i=0;i<64;i++){
            g->world[i]->id = i;
        }
    }
    return;
}

void InputHandle(Entity* player){
    player->acc = {0};
    if(IsKeyDown(KEY_A)) player->acc.x = -0.1;
    if(IsKeyDown(KEY_D)) player->acc.x =  0.1;
    if(IsKeyDown(KEY_W) && player->istouchingground) player->vel.y +=  1.5;
    if(IsKeyDown(KEY_S)) player->acc.y = -0.1;
    if(IsKeyPressed(KEY_KP_SUBTRACT) && WORLDSCALE > 1) WORLDSCALE--;
    if(IsKeyPressed(KEY_KP_ADD)) WORLDSCALE++;;
    return;
}

void EntityVelStep(Entity* a, GameInstance *g){
    Vector2 t = a->pos;
    float dx, dy, tx = .5, ty = .5; // deltax,deltay, stepping size x and y
    float pdwc = a->chunkdepth * 16;
    dx = a->vel.x; // how much the character will move this frame
    dy = a->vel.y;
    if(dx < 0) tx*=-1; // making them negative if they need to be
    if(dy < 0) ty*=-1;
    bool check = 0, yreturnnext = 0, xreturnnext=0;
    a->istouchingground = 0; // because if its touching the ground the next function will tell us
    while(fabs(dx) > 0 || fabs(dy) > 0){
        if (fabs(tx) > fabs(dx)) tx = dx; // if the stepsize is bigger than the delta remaining, set the step size to the delta
        if (fabs(ty) > fabs(dy)) ty = dy;
        Vector2 sizeiter = {0}, size = {a->size.x - 0.1f, a->size.y - 0.1f};
        check = 1;
        yreturnnext = 0; xreturnnext=0;
        int chunkoffset;
        if(fabs(dx) > 0){
            while(check){ // checking if the entire area of the entity doesnt collide with any walls in the x direction
                while(check){
                    chunkoffset = chunkoffset = 63 - (g->world[63]->replacementdepth + (((int)(t.y - sizeiter.y) >> 4)));;//(((int)(a->pos.y)) >> 4) - (((int)(t.y - sizeiter.y) >> 4));
                    check = check && !g->world[chunkoffset]->wd[(int)(t.x + tx + sizeiter.x)][(int)ceil(t.y + pdwc - sizeiter.y + 16)%16].v;
                    if(yreturnnext)break;
                    sizeiter.y+=1;
                    if(sizeiter.y>size.y) {sizeiter.y = size.y;yreturnnext=1;}
                }
                if(xreturnnext) break;
                yreturnnext = 0;
                sizeiter.y = 0;
                sizeiter.x+=1;
                if(sizeiter.x>size.x) {sizeiter.x = size.x;xreturnnext = 1;}
            }
            if(fabs(tx) > 0 && check){
                t.x += tx;
                dx-= tx;
            }
            else if (!check){
                dx = 0;
                a->vel.x = 0;
            }
        }
        sizeiter = {0,0};
        check = 1;
        yreturnnext = 0;xreturnnext = 0;
        if(fabs(dy) > 0){
            while(check){ // checking if the entire area of the entity doesnt collide with any walls in the y direction
                while(check){
                    chunkoffset = 63 - (g->world[63]->replacementdepth + (((int)ceil(t.y + ty - sizeiter.y) >> 4)));//(((int)(a->pos.y)) >> 4) - (((int)(t.y + ty - sizeiter.y) >> 4));
                    check = check && !g->world[chunkoffset]->wd[(int)(t.x + sizeiter.x)][(int)ceil(t.y + ty + pdwc - sizeiter.y + 16)%16].v;
                    if(yreturnnext)break;
                    sizeiter.y+=1;
                    if(sizeiter.y>size.y) {sizeiter.y = size.y;yreturnnext=1;} 
                }
                if(xreturnnext) break;
                yreturnnext = 0;
                sizeiter.y = 0;
                sizeiter.x+=1;
                if(sizeiter.x>size.x) {sizeiter.x = size.x;xreturnnext = 1;}
            }
            if(fabs(ty) > 0 && check){
                t.y += ty;
                dy-= ty;
            }
            else if (!check){
                dy = 0;
                if(a->vel.y < 0) a->istouchingground = 1;
                a->vel.y = 0;
            }
        }
    }
    a->pos = t;
}
void TickEntity(Entity* a, GameInstance* g){
    int chunkid = 63 - (g->world[63]->replacementdepth - a->chunkdepth);
    a->vel = Vector2Add(a->acc, a->vel);
    a->vel.y -=0.1; // gravity
    EntityVelStep(a, g);
    if     (a->pos.x < 0)  a->pos.x = 0;
    else if(a->pos.x > 255)a->pos.x = 255;
    if(a->istouchingground && a->acc.x == 0)a->vel.x = a->vel.x*=0.75;
    else a->vel = {(float)a->vel.x * 0.9f,(float)a->vel.y * 0.95f};
    a->chunkdepth = -(((int)a->pos.y) >> 4);
    return;
}

Vector2 PanCamera(Vector2 CameraPos, Vector2 targetpos, float interpolate, Vector2 offset){
    Vector2 t = Vector2Add(Vector2Scale(CameraPos, 1 - interpolate), Vector2Scale(Vector2Add(Vector2Scale(targetpos, WORLDSCALE), offset), interpolate));
    if(t.x < 0) t.x = 0;
    else if (t.x > 256 * WORLDSCALE - 640) t.x = 256 * WORLDSCALE - 640;
    return t;
}
float rand_seeded(float seed){
    float v = (sin(seed * 1234.1)*456.52);
    return v - floor(v);
}
float ValueNoise(Vector2 xy, float scalefactor, int seed = 125){
    float vals[2][2];
    int intxy[2];
    xy.x = xy.x * scalefactor;
    xy.y = xy.y * scalefactor;
    intxy[0] = (int)xy.x;
    intxy[1] = (int)xy.y;
    vals[0][0] = rand_seeded(seed + (intxy[0] + 0) * 1000.f + intxy[1] + 0);// fix this shit
    vals[1][0] = rand_seeded(seed + (intxy[0] + 1) * 1000.f + intxy[1] + 0);// fix this shit
    vals[0][1] = rand_seeded(seed + (intxy[0] + 0) * 1000.f + intxy[1] + 1);// fix this shit
    vals[1][1] = rand_seeded(seed + (intxy[0] + 1) * 1000.f + intxy[1] + 1);// fix this shit
    xy.x = xy.x - intxy[0];
    xy.y = xy.y - intxy[1];
    float result = (vals[1][1] * xy.x + vals[0][1] * (1 - xy.x)) * xy.y + (vals[1][0] * xy.x + vals[0][0] * (1 - xy.x)) * (1.f - xy.y); // magic numer is to convert it to a 0 to 1 value
    return (3  - result * 2) * result * result;
}

void generatechunk(Chunk* t){
    // if(t->depth != -12000){ // if this chunk isnt being loaded for the first time save it first
    //     int rdepth = t->replacementdepth, depth = t->depth;
    //     t->replacementdepth = t->depth;
    // TODO save to file somehow
    //     t->replacementdepth = rdepth;
    // }
    t->depth = t->replacementdepth;
    float v = t->depth * 0.01 * 0.25;
    for(int x=0;x<256;x++){ // placeholder
       for(int y=0;y<16;y++){
            float a = ValueNoise({(float)x,(float)(t->depth * 16 - y)}, 0.04f);
            a = a * 2 - 1;
            float b =-a;
            if(a < 0) a = 0;
            if(b < 0) b = 0;
            t->wd[x][y].v = (b + a)  - ValueNoise({(float)x,(float)(t->depth * 16 - y)}, 0.2f) * 0.1 - ValueNoise({(float)x,(float)(t->depth * 16 - y)}, 0.01f) * v + 0.125 > 0.1;
        }
    }
}
void debugmousedraw(GameInstance* game, int plch){// temporary drawing functions
    if(IsMouseButtonDown(MOUSE_BUTTON_LEFT) || IsMouseButtonDown(MOUSE_BUTTON_RIGHT)){ 
        Vector2 mp = GetMousePosition();
        mp.y = game->WindowHeight - mp.y;
        mp = Vector2Scale(Vector2Add(game->CameraPosition, mp), 1./WORLDSCALE);
        GlobalTilePosition a = GetTileFromPos(game, mp);
        game->world[a.chunkid]->wd[a.x][a.y].v = IsMouseButtonDown(MOUSE_BUTTON_LEFT);
    }
}
void GlobalTick(GameInstance* game){
    InputHandle(game->player);
    game->playerchunk = game->player->chunkdepth;
    bool checker;
    int plch = 63 - (game->world[63]->replacementdepth - game->player->chunkdepth);
    if(plch < 8) plch = 8; 
    for(auto ent = game->Entities.begin(); ent!=game->Entities.end(); ent++){
        TickEntity(*ent, game);
    }
    game->CameraPosition = PanCamera(game->CameraPosition, game->player->pos, 0.4, game->CameraCenterOffset);
    if(game->playerchunk!=game->player->chunkdepth)PlayerChangesChunkEvent(game);
    if(game->UnloadedChunks.size()>0){
        Chunk* t = game->UnloadedChunks.front();
        game->UnloadedChunks.pop_front();
        generatechunk(t);
    }
    debugmousedraw(game, plch);
}

void lightChunks(GameInstance *game){
    GlobalTilePosition a = GetTileFromPos(game, game->player->pos);
    game->world[a.chunkid]->wd[a.x][a.y].lightness = 255;

    for(int chunk = 0; chunk < 64; chunk++){
        int y = ((int)game->CameraPosition.y)/WORLDSCALE - abs(game->world[chunk]->depth * 16 + 10);// finding the highest part of the thing to draw
        if(y < 0) y = 0;
        for(
            y;
            (y - game->world[chunk]->depth * 16) * WORLDSCALE - game->CameraPosition.y < game->WindowHeight + WORLDSCALE * 10 && y < 16;
            y++)
        {
            for(
                int x = (game->CameraPosition.x > 0) * floor(game->CameraPosition.x / WORLDSCALE);
                x < (game->CameraPosition.x + game->WindowWidth) / WORLDSCALE && x < 256;
                x++)
            {
                if(game->world[chunk]->wd[x][y].lightness > 15){ // lighting code
                    for(int i=0;i<3;i++){
                        for(int j=0;j<3;j++){
                            unsigned char xv = x - 1 + i;
                            int yv = y - 1 + j;
                            char chunkoff = 0;
                            if(yv > 15 && (chunk > 0)){
                                yv = 0;
                                chunkoff = -1;
                            }
                            else if(yv < 0 && (chunk < 63)){
                                yv = 15;
                                chunkoff = 1;
                            }
                            unsigned char lv = (10 + 30 * game->world[chunk + chunkoff]->wd[xv][yv].v);
                            if(game->world[chunk + chunkoff]->wd[xv][yv].lightness < game->world[chunk]->wd[x][y].lightness - lv){
                                game->world[chunk + chunkoff]->wd[xv][yv].lightness = game->world[chunk]->wd[x][y].lightness - lv;
                            }
                        }
                    }
                }
            }
        }
    }
}

void drawChunks(GameInstance *game){
    lightChunks(game);

    for(int chunk = 0; chunk < 64; chunk++){
        int y = ((int)game->CameraPosition.y)/WORLDSCALE - abs(game->world[chunk]->depth * 16);// finding the highest part of the thing to draw
        if(y < 0) y = 0;
        for(
            y;
            (y - game->world[chunk]->depth * 16) * WORLDSCALE - game->CameraPosition.y < game->WindowHeight + WORLDSCALE && y < 16;
            y++)
        {
            for(
                int x = (game->CameraPosition.x > 0) * floor(game->CameraPosition.x / WORLDSCALE);
                x < (game->CameraPosition.x + game->WindowWidth) / WORLDSCALE && x < 256;
                x++)
            {
                unsigned char col = (unsigned char)(game->world[chunk]->wd[x][y].v * 100 + 100) * game->world[chunk]->wd[x][y].lightness*0.00392156862f;
                DrawTexturePro(game->textures[0], {0,0,16,16}, {x * WORLDSCALE - game->CameraPosition.x,game->WindowHeight - ((y - game->world[chunk]->depth * 16) * WORLDSCALE - game->CameraPosition.y), (float)WORLDSCALE, (float)WORLDSCALE}, {0,0}, 0, {(unsigned char)(col * 1.2), col, col, 255});
                //DrawRectangle(x * WORLDSCALE - game->CameraPosition.x, game->WindowHeight - ((y - game->world[chunk]->depth * 16) * WORLDSCALE - game->CameraPosition.y), WORLDSCALE, WORLDSCALE, {(unsigned char)(col * 1.2), col, col, 255});
                if(game->world[chunk]->wd[x][y].lightness > 5)game->world[chunk]->wd[x][y].lightness-=5; else game->world[chunk]->wd[x][y].lightness = 0;
            }
        }
    }
}


int main(void){
    SetTargetFPS(30);
    GameInstance game;
    game.player = new Entity;
    game.Entities.push_back(game.player);
    game.player->chunkdepth = 100;
    game.player->pos = {100, -8 - 100 * 16};
    game.player->acc = {0,0};
    game.player->vel = {0,0};
    game.CameraPosition = {100,8 - 100 * 16};
    game.WindowWidth = 640;
    game.WindowHeight = 480;
    game.CameraCenterOffset = {(float)(-game.WindowWidth / 2), (float)(16 - game.WindowHeight / 2)};
    game.HighestChunk = 10000;
    game.LowestChunk = -10000;
    for(int i=0;i<64;i++){
        game.world[i] = new Chunk;
    }
    for(int i=0;i<32;i++){
        //game.world[i]->depth = i - 16 + 100;
        game.world[i]->replacementdepth = i - 16 + 100;
        if(game.world[i]->replacementdepth < game.HighestChunk) game.HighestChunk = game.world[i]->replacementdepth; 
        if(game.world[i]->replacementdepth > game.LowestChunk) game.LowestChunk = game.world[i]->replacementdepth; 
        generatechunk(game.world[i]);
    }
    qsort((void*)game.world, 64, sizeof(Chunk*), ChunkPointerComp);
    for(int i=0;i<64;i++){
        game.world[i]->id = i;
    }
	InitWindow(game.WindowWidth, game.WindowHeight, "hello window");
    game.textures[0] = LoadTexture("resources\\tiles.png");
    float scale = 1;
    float iterationfloat = 0;
    bool FREEZE = 0;
    char testsquare[100][100];
    while(!WindowShouldClose()){
        GlobalTick(&game);
        if(FREEZE)
            std::cout << "stopping!!\n";
        FREEZE = IsKeyDown(KEY_V);
        iterationfloat+=0.1;
        BeginDrawing();
            ClearBackground(DARKGRAY);
            DrawText("retard test", 50,50,30,BLACK);
            Vector2 playerposscaled = Vector2Scale(game.player->pos, WORLDSCALE);
            drawChunks(&game);
            DrawRectangle(playerposscaled.x - game.CameraPosition.x, game.WindowHeight - (playerposscaled.y - game.CameraPosition.y ), WORLDSCALE * game.player->size.x, WORLDSCALE * game.player->size.y, GRAY);
            DrawTriangle({10 + 10 * cos(iterationfloat),10 + 10 * sin(iterationfloat)},{10 + 10 * cos(iterationfloat-1),10 + 10 * sin(iterationfloat - 1)},{10 + 10 * cos(iterationfloat - 3),10 + 10 * sin(iterationfloat - 3)},WHITE);
        EndDrawing();
    }
    CloseWindow();
    for(int i=0;i<64;i++){
        if(game.world[i] != nullptr)
            delete game.world[i];
    }
    for(int i=0;i<NUMTEXTURES;i++){
        UnloadTexture(game.textures[i]);
    }
    return 0;
}