#pragma once
#include <raylib.h>
#include <iostream>
#include <list>
#include <utility>


	struct RTile {
		Color* data; //raw pixel data
		std::list<int>* neighbors;//ordered as north east south and west;
		int occur = 0, id;
		void clear();
	};
	struct RTileset {
		RTile* tiles = nullptr;
		int numtiles = 0;
		char tsize;
		~RTileset();
	};

	RTile GenTile(Image* ref, int pos, char size);
	void RotateTile(RTile* t, char size);
	void DrawTile(RTile t, char size, char rot, int xo, int yo);
	RTile* CheckTilePresence(RTile* t, std::list<RTile>* ts, char size);

	RTileset* GenTileset(Image* ref, char _tilesize);

	struct MapTile;


	std::list<int> TileIntersection(std::list<int> a, std::list<int> b, RTileset* t);

	void FullTilePropogate(RTileset* t, MapTile* TileMap, MapTile* smallest, int neighborsize, int tmw, int tmh, bool* functioning, std::list<MapTile*>* touched);

	void TilePropogate(RTileset* t, MapTile* TileMap, MapTile* smallest, int neighborsize, int tmw, int tmh, bool* functioning);


	Image GenMap(int w, int h, RTileset* t, bool allowerrors = 0, bool paintresults = 0);

