#include "wfc.h"
	void RTile::clear() { if (data != nullptr) { delete[] data; data = nullptr; } if (neighbors != nullptr) { delete[] neighbors;  neighbors = nullptr; } }

	RTileset::~RTileset() {
		if (tiles != nullptr) {
			for (int i = 0; i < numtiles; i++) {
				tiles[i].clear();
			}
			delete[] tiles;
		}
	}
	RTile GenTile(Image* ref, int pos, char size) {
		//generates a tile with no neighbor rules MUST BE MANUALLY CLEARED OR RISK MEMORY LEAK
		RTile temp;
		temp.data = new Color[size * size];
		temp.neighbors = new std::list<int>[(size)*size];
		for (int i = 0; i < size * size; i++) {
			temp.data[i] = GetImageColor(*ref, pos % (ref->width - size) + i % size, pos / (ref->width - size) + i / size);
		}
		return temp;
	}
	void RotateTile(RTile* t, char size) {
		/*Color* newcols = new Color[size * size];
		for (int i = 0; i < size * size; i++) { // just trust me that this rotates it by 90 degrees lmao
				newcols[size - (1 + i/size) + size * (i%size)] = t->data[i];
		}
		t->clear();
		t->data = newcols;*/
	}
	void DrawTile(RTile t, char size, char rot, int xo, int yo) {
		for (int x = 0; x < size; x++) {
			for (int y = 0; y < size; y++) {
				DrawRectangle((x + xo) * 15, (y + yo) * 15, 15, 15, (t).data[x + y * size]);
			}
		}
	}

	RTile* CheckTilePresence(RTile* t, std::list<RTile>* ts, char size) {
		bool a = 0;
		for (auto i = ts->begin(); i != ts->end(); i++) {
			for (int j = 0; j < size * size; j++) {
				a = t->data[j].r == (*i).data[j].r && t->data[j].g == (*i).data[j].g && t->data[j].b == (*i).data[j].b;
				if (!a) break;
			}
			if (a) return &(*i);
		}
		return nullptr;
	}

	RTileset* GenTileset(Image* ref, char _tilesize) {
		RTileset* tileset = new RTileset;
		std::list<RTile> tiles;
		tileset->tsize = _tilesize;
		int tmw = (ref->width - tileset->tsize), tmh = (ref->height - tileset->tsize);
		RTile** TileMap = new RTile * [tmw * tmh];
		RTile temp, * focus = nullptr;
		for (int i = 0; i < tmw * tmh; i++) {
			temp = GenTile(ref, i, tileset->tsize);
			focus = CheckTilePresence(&temp, &tiles, tileset->tsize);
			if (focus == nullptr) {
				tiles.push_back(temp);
				focus = &tiles.back();
			}
			else {
				temp.clear();
			}
			focus->occur++;
			TileMap[i] = focus;
		}
		tileset->numtiles = tiles.size();
		tileset->tiles = new RTile[tileset->numtiles];
		auto ttt = tiles.begin();
		for (int i = 0; i < tileset->numtiles; i++) {
			tileset->tiles[i] = *ttt;
			tileset->tiles[i].id = i;
			if (tileset->tiles[i].neighbors == nullptr)
				std::cout << "SHIT\n";
			ttt->id = i;
			ttt++;
		}

		// establishing tileset neighboring rules
		int neighborsize = (tileset->tsize);// 27,12
		for (int x1 = 0; x1 < tmw; x1++) {
			for (int y1 = 0; y1 < tmh; y1++) {
				for (int x2 = 0; x2 < neighborsize; x2++) {
					for (int y2 = 0; y2 < neighborsize; y2++) {
						int x = x1 + x2 - (neighborsize / 2);
						int y = y1 + y2 - (neighborsize / 2);
						if (x >= 0 && x < tmw && y >= 0 && y < tmh) {
							tileset->tiles[TileMap[x1 + y1 * tmw]->id].neighbors[x2 + y2 * neighborsize].push_back(TileMap[x + y * tmw]->id); // TODO fix this
						}
					}
				}
			}
		}
		for (int j = 0; j < tileset->numtiles; j++) {
			for (int i = 0; i < neighborsize * neighborsize; i++) {
				tileset->tiles[j].neighbors[i].sort();
				tileset->tiles[j].neighbors[i].unique();
			}
		}
		delete[] TileMap;
		//tileset->tiles.sort();
		std::cout << "Tileset creation complete\n";
		return tileset;
	}

	struct MapTile {
		std::list<int> ptiles; // list of possible tiles and tile orentations
		int xpos, ypos, id; // its position in the world
		char collapsed = 0;
	};


	std::list<int> TileIntersection(std::list<int> a, std::list<int> b, RTileset* t) {
		auto i = a.begin();
		auto j = b.begin();
		std::list<int> intersection;
		while (i != a.end() && j != b.end()) {
			if (*j > *i) {
				i++;
			}
			else if (*j < *i) {
				j++;
			}
			else {
				intersection.push_back(*j);
				i++;
				j++;
			}
		}
		return intersection;
	}

	void FullTilePropogate(RTileset* t, MapTile* TileMap, MapTile* smallest, int neighborsize, int tmw, int tmh, bool* functioning, std::list<MapTile*>* touched) {
		std::list<int> potential;
		if (touched->size() < 10) {
			for (int j = 0; j < neighborsize * neighborsize; j++) {
				int x = smallest->xpos + j % neighborsize - (neighborsize / 2);
				int y = smallest->ypos + j / neighborsize - (neighborsize / 2);
				if (x >= 0 && x < tmw && y >= 0 && y < tmh) {
					if (TileMap[x + y * tmw].collapsed == 0) {
						potential.clear();
						for (auto i = smallest->ptiles.begin(); i != smallest->ptiles.end(); i++) {
							potential.insert(potential.end(), t->tiles[*i].neighbors[j].begin(), t->tiles[*i].neighbors[j].end());
						}
						potential.sort();
						potential.unique();
						if (potential.size() < t->numtiles) {
							std::list<int> templ = TileIntersection(TileMap[x + y * tmw].ptiles, potential, t);
							if (templ.size() != TileMap[x + y * tmw].ptiles.size()) {
								TileMap[x + y * tmw].collapsed = 1;
								touched->push_back(&TileMap[x + y * tmw]);
							}
							if (templ.size() == 0)
								*functioning = 0;
							else
								TileMap[x + y * tmw].ptiles = templ;
						}
					}
				}
			}
		}
		else
			*functioning = 0;
		return;
	}

	void TilePropogate(RTileset* t, MapTile* TileMap, MapTile* smallest, int neighborsize, int tmw, int tmh, bool* functioning) {
		std::list<MapTile*> touched;
		for (int j = 0; j < neighborsize * neighborsize; j++) {
			int x = smallest->xpos + j % neighborsize - (neighborsize / 2);
			int y = smallest->ypos + j / neighborsize - (neighborsize / 2);
			if (x >= 0 && x < tmw && y >= 0 && y < tmh) {
				if (TileMap[x + y * tmw].collapsed == 0) {
					if (t->tiles[smallest->ptiles.front()].neighbors[j].size() < t->numtiles) {
						std::list<int> templ = TileIntersection(TileMap[x + y * tmw].ptiles, t->tiles[smallest->ptiles.front()].neighbors[j], t);
						if (templ.size() != TileMap[x + y * tmw].ptiles.size()) {
							TileMap[x + y * tmw].collapsed = 1;
							touched.push_back(&TileMap[x + y * tmw]);
						}
						if (templ.size() == 0)
							*functioning = 0;
						else
							TileMap[x + y * tmw].ptiles = templ;
					}
				}
			}
		}
		for (auto i = touched.begin(); i != touched.end(); i++) {
			if ((*i)->ptiles.size() != t->numtiles)
				FullTilePropogate(t, TileMap, *i, neighborsize, tmw, tmh, functioning, &touched);
		}

		for (auto i = touched.begin(); i != touched.end(); i++) {
			(*i)->collapsed = 0;
		}
		return;
	}


	Image GenMap(int w, int h, RTileset* t, bool allowerrors, bool paintresults) { // assumes rotation is on for now
	START:Image a = GenImageColor(w, h, { 0,0,0,0 });
		int tmw = (w - t->tsize) + 1, tmh = (h - t->tsize) + 1;
		MapTile* TileMap = new MapTile[tmw * tmh]; // array of lists which holds the possible orentations of tiles for this spot
		MapTile** uncollapsed = new MapTile * [tmw * tmh];
		int uncollapsednum = tmw * tmh;
		for (int i = 0; i < tmw * tmh; i++) { // generating the map and assigning tiles
			for (int j = 0; j != t->numtiles; j++) {
				TileMap[i].ptiles.push_back(j);
			}
			TileMap[i].ptiles.sort();
			TileMap[i].xpos = i % tmw;
			TileMap[i].ypos = i / tmw;
			TileMap[i].id = i;
			uncollapsed[i] = &TileMap[i];
		}
		TileMap[(tmw * tmh) / 2 + tmw / 2].ptiles.clear();
		TileMap[(tmw * tmh) / 2 + tmw / 2].ptiles.push_back(rand() % t->numtiles);

		bool functioning = 1;
		while (uncollapsednum > 0 && (functioning || allowerrors)) {
			if (paintresults && !(uncollapsednum % 250)) {
				BeginDrawing();
				ClearBackground(DARKBLUE);
				for (int x = 0; x < w; x++) {
					for (int y = 0; y < h; y++) {
						DrawRectangle(x * 4, y * 4, 4, 4, GetImageColor(a, x, y));
					}
				}
				EndDrawing();
			}
			// finding the smallest entropy tile
			MapTile* smallest = uncollapsed[0];
			int chck = tmw / 4 + rand() % (tmw);
			for (int i = 0; i < uncollapsednum; i++) {
				if ((uncollapsed[i])->ptiles.size() <= smallest->ptiles.size()) {
					if ((uncollapsed[i])->ptiles.size() < smallest->ptiles.size() || !(i % chck))
						smallest = (uncollapsed[i]);
				};
			}

			//picking a random tile to collapse it into
			RTile* focus = &t->tiles[smallest->ptiles.front()];
			{
				int sumoccur = 0;
				for (auto i = smallest->ptiles.begin(); i != smallest->ptiles.end(); i++) {
					sumoccur += t->tiles[(*i)].occur;
				}
				int stopnum = rand() % (sumoccur);
				auto smiter = smallest->ptiles.begin();
				int inneroccur = t->tiles[(*smiter)].occur;

				for (int i = 0; i < stopnum && smiter != smallest->ptiles.end(); i++) {
					focus = &t->tiles[(*smiter)];
					if (inneroccur == 0) {
						smiter++;
						inneroccur = t->tiles[(*smiter)].occur;
					}
					inneroccur--;
				}
			}

			//collapsing the tile
			smallest->ptiles.clear();
			smallest->ptiles.push_back(focus->id);
			smallest->collapsed = 1;
			for (int i = 0; i < t->tsize * t->tsize; i++) {
				if (GetImageColor(a, smallest->xpos + i % t->tsize, smallest->ypos + i / t->tsize).a == 0)
					ImageDrawPixel(&a, smallest->xpos + i % t->tsize, smallest->ypos + i / t->tsize, focus->data[i]);
			}
			int magicnumber = 0;
			int neighborsize = t->tsize;

			// establishing neighborship rules
			TilePropogate(t, TileMap, smallest, neighborsize, tmw, tmh, &functioning);
			uncollapsednum--;
			uncollapsed[uncollapsednum]->id = smallest->id;
			uncollapsed[smallest->id] = uncollapsed[uncollapsednum];
		}
		delete[] uncollapsed;
		delete[] TileMap;
		if (!(functioning || allowerrors)) {
			std::cout << "error placing tile, generating new map. maybe consider enabling allow errors?\n";
			UnloadImage(a);
			goto START;
		}
		return a;
	}


/*int main() {
	const int WorldWidth = 100, WorldHeight = 60;
	//srand(5);
	const int WindowWidth = 1920/32*30, WindowHeight = 1080/32*30;
	//SetTargetFPS(15);

	Image ref = LoadImage("resources\\template.png");
	int tilenum = 0;
	WFC::RTileset *t = WFC::GenTileset(&ref, 3);
	//SetTargetFPS(30);
	int deez = 0;
	Image a;
	int iters = 0;
	srand(155);
	//while (1) {
	iters++;
	std::cout << iters << '\n';
	InitWindow(WindowWidth, WindowHeight, "hello window");
	SetTargetFPS(15);
	a = WFC::GenMap(200, 200, t, 1);
	std::cout << GetTime() << '\n';
	//}
	Texture map = LoadTextureFromImage(a);
	ExportImage(a, "generatedmap.png");
	while (!WindowShouldClose()) {
			BeginDrawing();
			ClearBackground(DARKBLUE);
			DrawTextureEx(map, { 0,0 }, 0, 4, WHITE);
			EndDrawing();
	}
	CloseWindow();
	UnloadImage(ref);
	delete t;
}*/