#pragma once
#include <raylib.h>
#include <rlgl.h>
#include <math.h>


struct frustumshader{
    Shader shader;
    Texture dummy;
    int nx1ID;
    int ny1ID;
    int nx2ID;
    int ny2ID;
    int fx1ID;
    int fy1ID;
    int fx2ID;
    int fy2ID;
    int flipID;
    int textureID;
};

frustumshader createfrustumshader();

void deletefrustumshader(frustumshader s);

void drawfrustum(frustumshader s, Texture texture, float near, float far, float fov, float angle, Vector2 position, int flip, Rectangle r);

struct noiseshader{
    Shader shader;
    int seedID, modID, scaleID, octavesID, offsetID;
    int nx1ID;
    int ny1ID;
    int nx2ID;
    int ny2ID;
    int fx1ID;
    int fy1ID;
    int fx2ID;
    int fy2ID;
    int flipID;
    int tintID;
    Texture dummy;
};
noiseshader createnoiseshader();

void deletenoiseshader(noiseshader s);

void drawnoise(noiseshader s, float seed, int mod, float scale, int octaves, Vector3 offset, float near, float far, float fov, float angle, Vector2 position, int flip,Rectangle rect, Color tint = WHITE);