#include "shaders.h"
frustumshader createfrustumshader(){
    frustumshader t;
    t.shader = LoadShader(0, "frustum.fs");
    Image d = GenImageColor(1,1,WHITE);
    t.dummy = LoadTextureFromImage(d);
    UnloadImage(d);
    t.nx1ID = GetShaderLocation(t.shader, "nx1");
    t.ny1ID = GetShaderLocation(t.shader, "ny1");
    t.nx2ID = GetShaderLocation(t.shader, "nx2");
    t.ny2ID = GetShaderLocation(t.shader, "ny2");
    t.fx1ID = GetShaderLocation(t.shader, "fx1");
    t.fy1ID = GetShaderLocation(t.shader, "fy1");
    t.fx2ID = GetShaderLocation(t.shader, "fx2");
    t.fy2ID = GetShaderLocation(t.shader, "fy2");
    t.flipID = GetShaderLocation(t.shader, "flip");
    return t;
}

void deletefrustumshader(frustumshader s){
    UnloadShader(s.shader);
    UnloadTexture(s.dummy);
}

void drawfrustum(frustumshader s, Texture texture, float near, float far, float fov, float angle, Vector2 position, int flip, Rectangle r){
        float nx1 = 0, ny1 = 0, nx2 = 0, ny2 = 0;
        float fx1 = 0, fy1 = 0, fx2 = 0, fy2 = 0;
        float val = 1./cos(-fov);
        nx1 = position.x + cos(angle - fov) * near*val;
        fx1 = position.x + cos(angle - fov) * far *val;
        nx2 = position.x + cos(angle + fov) * near*val;
        fx2 = position.x + cos(angle + fov) * far *val;
        ny1 = position.y + sin(angle - fov) * near*val;
        fy1 = position.y + sin(angle - fov) * far *val;
        ny2 = position.y + sin(angle + fov) * near*val;
        fy2 = position.y + sin(angle + fov) * far *val;
        
        
        SetShapesTexture(texture, {0.,0.,(float)texture.height,(float)texture.width});
        SetShaderValue(s.shader, s.fx1ID, (void*)&fx1, SHADER_UNIFORM_FLOAT);
        SetShaderValue(s.shader, s.fy1ID, (void*)&fy1, SHADER_UNIFORM_FLOAT);
        SetShaderValue(s.shader, s.fx2ID, (void*)&fx2, SHADER_UNIFORM_FLOAT);
        SetShaderValue(s.shader, s.fy2ID, (void*)&fy2, SHADER_UNIFORM_FLOAT);
        SetShaderValue(s.shader, s.nx1ID, (void*)&nx1, SHADER_UNIFORM_FLOAT);
        SetShaderValue(s.shader, s.ny1ID, (void*)&ny1, SHADER_UNIFORM_FLOAT);
        SetShaderValue(s.shader, s.nx2ID, (void*)&nx2, SHADER_UNIFORM_FLOAT);
        SetShaderValue(s.shader, s.ny2ID, (void*)&ny2, SHADER_UNIFORM_FLOAT);
        SetShaderValue(s.shader, s.flipID, (void*)&flip, SHADER_UNIFORM_INT);
        BeginShaderMode(s.shader);
        DrawRectangleRec(r, WHITE);
        EndShaderMode();
        SetShapesTexture(s.dummy, {0.,0.,1,1});
}


noiseshader createnoiseshader(){
    noiseshader s;
    //noise related uniforms
    s.shader = LoadShader(0, "noiseshader.fs");
    s.modID = GetShaderLocation(s.shader, "modv");
    s.octavesID = GetShaderLocation(s.shader, "octaves");
    s.scaleID = GetShaderLocation(s.shader, "scale");
    s.seedID = GetShaderLocation(s.shader, "seedv");
    s.offsetID = GetShaderLocation(s.shader, "offset");
    //frustum related uniforms
    
    s.nx1ID = GetShaderLocation(s.shader, "nx1");
    s.ny1ID = GetShaderLocation(s.shader, "ny1");
    s.nx2ID = GetShaderLocation(s.shader, "nx2");
    s.ny2ID = GetShaderLocation(s.shader, "ny2");
    s.fx1ID = GetShaderLocation(s.shader, "fx1");
    s.fy1ID = GetShaderLocation(s.shader, "fy1");
    s.fx2ID = GetShaderLocation(s.shader, "fx2");
    s.fy2ID = GetShaderLocation(s.shader, "fy2");
    s.flipID = GetShaderLocation(s.shader, "flip");
    s.tintID = GetShaderLocation(s.shader, "tint");
    Image d = GenImageColor(1,1,WHITE);
    s.dummy = LoadTextureFromImage(d);
    UnloadImage(d);
    return s;
}

void deletenoiseshader(noiseshader s){
    UnloadShader(s.shader);
    UnloadTexture(s.dummy);
}

void drawnoise(noiseshader s, float seed, int mod, float scale, int octaves, Vector3 offset, float near, float far, float fov, float angle, Vector2 position, int flip,Rectangle rect, Color tint){
    //noise related uniforms
    SetShaderValue(s.shader, s.modID, (void*)&mod, SHADER_UNIFORM_INT);
    SetShaderValue(s.shader, s.octavesID, (void*)&octaves, SHADER_UNIFORM_INT);
    SetShaderValue(s.shader, s.scaleID, (void*)&scale, SHADER_UNIFORM_FLOAT);
    SetShaderValue(s.shader, s.seedID, (void*)&seed, SHADER_UNIFORM_FLOAT);
    SetShaderValue(s.shader, s.offsetID, (void*)&offset, SHADER_UNIFORM_VEC3);
    //frustum related uniforms
    float nx1 = 0, ny1 = 0, nx2 = 0, ny2 = 0;
    float fx1 = 0, fy1 = 0, fx2 = 0, fy2 = 0;
    float val = 1./cos(-fov);
    nx1 = position.x + cos(angle - fov) * near*val;
    fx1 = position.x + cos(angle - fov) * far *val;
    nx2 = position.x + cos(angle + fov) * near*val;
    fx2 = position.x + cos(angle + fov) * far *val;
    ny1 = position.y + sin(angle - fov) * near*val;
    fy1 = position.y + sin(angle - fov) * far *val;
    ny2 = position.y + sin(angle + fov) * near*val;
    fy2 = position.y + sin(angle + fov) * far *val;

    float ftint[4] = {1,0,0,1};
    ftint[0] = tint.r * 0.00392156862;
    ftint[1] = tint.b * 0.00392156862;
    ftint[2] = tint.g * 0.00392156862;
    ftint[3] = tint.a * 0.00392156862;
    
    SetShaderValue(s.shader, s.fx1ID, (void*)&fx1, SHADER_UNIFORM_FLOAT);
    SetShaderValue(s.shader, s.fy1ID, (void*)&fy1, SHADER_UNIFORM_FLOAT);
    SetShaderValue(s.shader, s.fx2ID, (void*)&fx2, SHADER_UNIFORM_FLOAT);
    SetShaderValue(s.shader, s.fy2ID, (void*)&fy2, SHADER_UNIFORM_FLOAT);
    SetShaderValue(s.shader, s.nx1ID, (void*)&nx1, SHADER_UNIFORM_FLOAT);
    SetShaderValue(s.shader, s.ny1ID, (void*)&ny1, SHADER_UNIFORM_FLOAT);
    SetShaderValue(s.shader, s.nx2ID, (void*)&nx2, SHADER_UNIFORM_FLOAT);
    SetShaderValue(s.shader, s.ny2ID, (void*)&ny2, SHADER_UNIFORM_FLOAT);
    SetShaderValue(s.shader, s.flipID, (void*)&flip, SHADER_UNIFORM_INT);
    SetShaderValue(s.shader, s.tintID, (void*)&ftint, SHADER_UNIFORM_VEC4);


    SetShapesTexture(s.dummy, {0.,0.,1,1});
    BeginShaderMode(s.shader);
    DrawRectangleRec(rect, WHITE);
    EndShaderMode();
}