#version 330

// Input vertex attributes (from vertex shader)
in vec2 fragTexCoord;
in vec4 fragColor;
// Output fragment color
out vec4 finalColor;

//noise related uniforms
uniform float seedv;
uniform int modv;
uniform float scale;
uniform int octaves;
uniform vec3 offset;

//frustum related uniforms
uniform float nx1;
uniform float ny1;
uniform float nx2;
uniform float ny2;
uniform float fx1;
uniform float fy1;
uniform float fx2;
uniform float fy2;
uniform int flip;

//final uniforms
uniform vec4 tint;

float rand(float i){
    return fract(sin(i*1.575 + seedv)*160.35);
}
float noise(vec3 i, float v){
    i = i * scale * v + offset * v;
    vec3 tr;
    vec3 bl;
    tr = ceil(i);
    bl = floor(i);
    i = fract(i);
    i = i*i*(3.-2.*i);
    float top = (rand(tr.x + tr.y * 64. + tr.z * 512.) * (i.x)) + (rand(bl.x +  tr.y*64. + tr.z * 512.) * (1. - i.x));
    float bot = (rand(tr.x + bl.y * 64. + tr.z * 512.) * (i.x)) + (rand(bl.x +  bl.y*64. + tr.z * 512.) * (1. - i.x));
    float b = top * i.y + bot * (1. - i.y); 
    top = (rand(tr.x + tr.y * 64. + bl.z * 512.) * (i.x)) + (rand(bl.x +  tr.y*64. + bl.z * 512.) * (1. - i.x));
    bot = (rand(tr.x + bl.y * 64. + bl.z * 512.) * (i.x)) + (rand(bl.x +  bl.y*64. + bl.z * 512.) * (1. - i.x));
    float f = top * i.y + bot * (1. - i.y);
    return b * i.z + f * (1-i.z);
    //return 0.;
}
vec4 samplenoise(vec3 _uv){
    
    vec3 uv = _uv;
    vec4 col = vec4(0);
    col.a = 1;
    float s = 0;
    float j = 0.5;
    float v = 1.;
    for(int i=0; i<octaves; i++){
        col = col + vec4(noise(uv, v)*j);
        v=v*2;
        s = s + j;
        j= j * 0.5;
    }
    col = col / s;
    return col;
}
void main()
{
    float startx;
    float starty;
    float endx;
    float endy;
	if(flip != 0){
		startx = (fx1 - nx1) / (1. - fragTexCoord.y) + nx1;
		starty = (fy1 - ny1) / (1. - fragTexCoord.y) + ny1;
		endx = (fx2 - nx2) /   (1. - fragTexCoord.y) + nx2;
		endy = (fy2 - ny2) /   (1. - fragTexCoord.y) + ny2;
	}
    else{
		startx = (fx1 - nx1) / (fragTexCoord.y) + nx1;
		starty = (fy1 - ny1) / (fragTexCoord.y) + ny1;
		endx = (fx2 - nx2) /   (fragTexCoord.y) + nx2;
		endy = (fy2 - ny2) /   (fragTexCoord.y) + ny2;
    }
	float xsample = (endx - startx) * (fragTexCoord.x) + startx;
	float ysample = (endy - starty) * (fragTexCoord.x) + starty;
    xsample = round(xsample*40.)/40.;
    ysample = round(ysample*40.)/40.;
	vec4 texelColor = samplenoise(vec3(xsample, ysample, 0));
	//texelColor = vec4(1);
    //texelColor = texelColor * texelColor;
    float tmp = 0.15;
    texelColor = (texelColor + vec4(tmp))/(1. + tmp);
    float o = texelColor.r * texelColor.r;
	finalColor = texelColor * texelColor; 
    finalColor.a = ceil(min(o*2,0.6)*8)/8/0.6;
    finalColor = finalColor * tint;
    finalColor.a = finalColor.a * finalColor.a;
}