#include "helper.h"

float sqdist(float x1, float y1, float x2, float y2) {
	return (x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2);
}
float sqdistV(Vector2 a1, Vector2 a2) {
	return sqdist(a1.x, a1.y, a2.x, a2.y);
}
float angfromto(Vector2 a, Vector2 b) {
	float xp = b.x - a.x, yp = b.y - a.y;
	float ang = atan(yp / xp);
	if (xp < 0) {
		ang += PI;
	}
	return ang;
}
void tickentity(Entity* e, World* a) {
	e->frameoffset++;
	e->ang = fmod(2 * PI + e->ang, 2 * PI);
	e->vel.x = (e->vel.x + e->acc.x);
	e->vel.y = (e->vel.y + e->acc.y);
	if (e->NOCLIP || a->tiles[(int)(e->pos.x + e->vel.x + e->size)][(int)(e->pos.y + e->size)] == 0 && a->tiles[(int)(e->pos.x + e->vel.x - e->size)][(int)(e->pos.y + e->size)] == 0 && a->tiles[(int)(e->pos.x + e->vel.x + e->size)][(int)(e->pos.y - e->size)] == 0 && a->tiles[(int)(e->pos.x + e->vel.x - e->size)][(int)(e->pos.y - e->size)] == 0) {
		e->pos.x += e->vel.x;
	}
	else e->vel.x = 0;
	if (e->NOCLIP || a->tiles[(int)(e->pos.x + e->size)][(int)(e->pos.y + e->vel.y + e->size)] == 0 && a->tiles[(int)(e->pos.x - e->size)][(int)(e->pos.y + e->vel.y + e->size)] == 0 && a->tiles[(int)(e->pos.x + e->size)][(int)(e->pos.y + e->vel.y - e->size)] == 0 && a->tiles[(int)(e->pos.x - e->size)][(int)(e->pos.y + e->vel.y - e->size)] == 0) {
		e->pos.y += e->vel.y;
	}
	else e->vel.y = 0;
	if (!e->NOCLIP) {
		e->vel.x *= 0.5;
		e->vel.y *= 0.5;
	}
	else {
		e->vel.x *= 0.9;
		e->vel.y *= 0.9;
	}
	if (a->ents[0].pos.x > e->pos.x) 
		e->acc.x = 1;
	else
		e->acc.x = -1;
	float xp = e->pos.x - a->ents[0].pos.x, yp = e->pos.y - a->ents[0].pos.y;
	e->dist = sqrt(xp * xp + yp * yp);
	if (e->ang != a->ents[0].ang) e->ang = e->ang + 0.25*(rand()%3-1);//angfromto(e->pos, a->ents[0].pos);//
	e->acc.x = cos(e->ang) * 0.125 * 0.25;
	e->acc.y = sin(e->ang) * 0.125 * 0.25;
}
void tickplayer(Player* p, World* a, Image* map) {
	p->body->acc.x = 0;
	p->body->acc.y = 0;
	if (IsKeyDown(KEY_A) && (p->looktoggle)) {
		p->body->ang -= 0.125;
	}
	else if (IsKeyDown(KEY_A)) {
		p->body->acc.y += sin(p->body->ang - PI * 0.5) * 0.125 * 0.8;
		p->body->acc.x += cos(p->body->ang - PI * 0.5) * 0.125 * 0.8;
	}
	if (IsKeyDown(KEY_D) && (p->looktoggle))
		p->body->ang += 0.125;
	else if (IsKeyDown(KEY_D)) {
		p->body->acc.y += sin(p->body->ang + PI * 0.5) * 0.125 * 0.8;
		p->body->acc.x += cos(p->body->ang + PI * 0.5) * 0.125 * 0.8;
	}
	if (IsKeyDown(KEY_Q) && (p->looktoggle)) {
		p->body->acc.y += sin(p->body->ang - PI * 0.5) * 0.125 * 0.8;
		p->body->acc.x += cos(p->body->ang - PI * 0.5) * 0.125 * 0.8;
	}
	else if (IsKeyDown(KEY_Q)) {
		p->body->ang -= 0.125;
	}
	if (IsKeyDown(KEY_E) && (p->looktoggle)) {
		p->body->acc.y += sin(p->body->ang + PI * 0.5) * 0.125 * 0.8;
		p->body->acc.x += cos(p->body->ang + PI * 0.5) * 0.125 * 0.8;
	}
	else if (IsKeyDown(KEY_E)) {
		p->body->ang += 0.125;
	}
	if (IsKeyDown(KEY_W)) {
		p->body->acc.y += sin(p->body->ang) * 0.125;
		p->body->acc.x += cos(p->body->ang) * 0.125;
	}
	if (IsKeyDown(KEY_S)) {
		p->body->acc.y += sin(p->body->ang + PI) * 0.125;
		p->body->acc.x += cos(p->body->ang + PI) * 0.125;
	}
	if (IsKeyPressed(KEY_GRAVE)) p->body->NOCLIP = !p->body->NOCLIP;
	if (!p->looktoggle) {
		p->body->ang += GetMouseDelta().x * PI * 0.003;
		SetMousePosition(400, 400);
	}
	if (IsKeyPressed(KEY_TAB)) (p->looktoggle) = !(p->looktoggle);
	if (IsKeyPressed(KEY_M)) (p->maptoggle) = !(p->maptoggle);
	if (IsKeyPressed(KEY_KP_ADD)) p->fov *= 1.1;
	if (IsKeyPressed(KEY_KP_SUBTRACT)) p->fov /= 1.1;
	if (IsMouseButtonPressed(MOUSE_BUTTON_LEFT) && a->tiles[(int)(p->body->pos.x + cos(p->body->ang) * 0.5)][(int)(p->body->pos.y + sin(p->body->ang) * 0.5)] == 1) a->tiles[(int)(p->body->pos.x + cos(p->body->ang) * 0.5)][(int)(p->body->pos.y + sin(p->body->ang) * 0.5)] = 0;
	static int mappingray = 0; // this is the ray currently selected to be used for mapping
	mappingray = (mappingray + 11 )% 256;
	for (int i = 0; i < 256; i++) {
		if(i == mappingray)
			p->visionrays[i].cast(a->tiles, a->width, a->height, p->body->pos, p->body->ang + atan(0.015625 * p->fov * (i - 128)), map); // potential optimization by caching the arctangent values
		else
			p->visionrays[i].cast(a->tiles, a->width, a->height, p->body->pos, p->body->ang + atan(0.015625 * p->fov * (i - 128))); // potential optimization by caching the arctangent values
		p->visionrays[i].id = i;
	}
	qsort(p->visionrays, 256, sizeof(VRay), VRayCompare);
}
int CompareEnts(const void* p1, const void* p2)
{
	Entity *a = ((Entity*)p1);
	Entity *b = ((Entity*)p2);

	if (a->dist == b->dist) return 0;
	else if (a->dist > b->dist) return -1;
	else return 1;
}


void checkcollisions(World* a) {
	for (int i = 0; i < a->numents; i++) {
		for (int j = i + 1; j < a->numents; j++) {
			float d = sqdistV(a->ents[i].pos, a->ents[j].pos);
			if ( d < (a->ents[i].size + a->ents[j].size) * (a->ents[i].size + a->ents[j].size)) {
				d = sqrt(d);
				a->ents[i].vel.x -= (a->ents[j].pos.x - a->ents[i].pos.x) / (d) * 0.1;//* 0.5 * a->ents[j].size;
				a->ents[i].vel.y -= (a->ents[j].pos.y - a->ents[i].pos.y) / (d) * 0.1;//* 0.5 * a->ents[j].size;
				a->ents[j].vel.x -= (a->ents[i].pos.x - a->ents[j].pos.x) / (d) * 0.1;//* 0.5 * a->ents[i].size;
				a->ents[j].vel.y -= (a->ents[i].pos.y - a->ents[j].pos.y) / (d) * 0.1;//* 0.5 * a->ents[i].size;
			}
		}
	}
}
void drawview(Player* p, World* w, int height, int width, Texture2D* textures, Texture2D* enttexs, frustumshader s, noiseshader ns) {
	VRay* foc;
	float val;
	float skip = width / 256.0;
	Rectangle src, dst;
	//DrawRectangle(0, 0, width, height / 2, BLACK);
	float cosval, floorstep;
	Rectangle rect = {0,0, (float)width, (float)(height/2)};
	Vector2 fspos = p->body->pos;
	static long scroll = 0;
	scroll++;
	float frfov = 4.07/(p->fov + 1.45) - 0.537;
	fspos.x = 0;
	fspos.y = 0;
	drawfrustum(s, textures[4], 0, 1.5, p->fov * frfov, p->body->ang,fspos, 1, rect);
	fspos.x = p->body->pos.x * 0.01;// - scroll*0.00025;
	fspos.y = p->body->pos.y * 0.01;// - scroll*0.00035;
	//   drawfrustum(s, textures[6], 0, 0.3, p->fov * frfov, p->body->ang,fspos, 1, rect);//1.5 is the far value for ceilings
	//if((scroll>>3)%2)
	drawnoise(ns, 0, 0, 8, 3, {(float)(-scroll*0.0025),(float)(-scroll*0.0035), (float)(scroll * 0.006)}, 0, 0.7, p->fov * frfov, p->body->ang,fspos, 1, rect, {200,125,125,255});
	//drawnoise(ns, 0, 0, 8, 3, {0,0, (float)(scroll * 0.012)}, 0, 0.5, p->fov * frfov, p->body->ang,fspos, 1, rect, {0,125,255,150}); // sorta cool looking aurora effect
	fspos.x = p->body->pos.x * 0.02;// + scroll*0.00075;
	fspos.y = p->body->pos.y * 0.02;// + scroll*0.0005;
	//   drawfrustum(s, textures[5], 0, 0.5, p->fov * frfov, p->body->ang,fspos, 1, rect);
	//if(((scroll>>3) + 1)%2)
	drawnoise(ns, 0, 0, 8, 3, {(float)(scroll*0.0075),(float)(scroll*0.005), (float)(scroll * 0.006)}, 0, 1.3, p->fov * frfov, p->body->ang,fspos, 1, rect, {220,175,175,255}); // TODO add opacity modifier uniform and color tint uniform, potentially add threshhold for opacity
	rect.y = height/2;
	drawfrustum(s, textures[3], 0, 0.5, p->fov * frfov, p->body->ang,p->body->pos, 0, rect);
	DrawRectangleGradientV(0, height/2, width, height/2, {25,0,0,155}, {0,0,0,0});
	DrawRectangleGradientV(0, 0, width, height/2, {0,0,0,0}, {25,0,0,200});
	for (int i = 0; i < 256; i++) {

		//setting up for drawing the wall	
		foc = &(p->visionrays[i]);
		cosval = cos(foc->ang - p->body->ang);
		val = 1 / (foc->dist * cosval);
		src.x = (foc->xhit - floor(foc->xhit)) * textures[foc->hit].width + (foc->yhit - floor(foc->yhit)) * textures[foc->hit].width;
		src.y = 0;
		src.height = textures[foc->hit].height;
		src.width = 0;
		dst.x = p->visionrays[i].id * skip;
		dst.y = height * 0.5 - height * val * 0.75;//*0.75
		dst.width = skip;
		dst.height = height * val * 1;
		//actually drawing the walls lol
		if (foc->xhit - floor(foc->xhit) != 0 && foc->hit != 0)
			DrawTexturePro(textures[foc->hit % 3], src, dst, { 0.0,0.0 }, 0, { (unsigned char)(255 - foc->dist * 7),(unsigned char)(255 - foc->dist * 10),(unsigned char)(255 - foc->dist * 10),255 });//{ (unsigned char)(255 - foc->dist * 4.5),(unsigned char)(255 - foc->dist * 4.5),(unsigned char)(255 - foc->dist * 4.5),255 }
		else
			DrawTexturePro(textures[foc->hit % 3], src, dst, { 0.0,0.0 }, 0, { (unsigned char)(150 - foc->dist * 3),(unsigned char)(150 - foc->dist * 6),(unsigned char)(150 - foc->dist * 6),255 });
	}
	for (int i = 1; i < w->numents; i++) {
		drawentity(&(w->ents[i]), p, width, height, enttexs);
	}
	static float v;
	v += (p->body->vel.y * p->body->vel.y + p->body->vel.x * p->body->vel.x) * 20;
	DrawTextureEx(textures[5], {(float)(width - textures[5].width * 5 + 15 + cos(v) * 15),(float)(height - textures[5].height * 5 + 15 + sin(v*2) * 15)}, 0, 5, WHITE);
}

void drawentity(Entity* e, Player* p, int width, int height, Texture2D *textures) {
	float skip = width / 256.0;
	float xp = e->pos.x - p->body->pos.x, yp = e->pos.y - p->body->pos.y;
	float a = atan(yp / xp);
	float arclength = atan((e->size * 1.5) / e->dist);
	float da = fmod(PI * 4 + e->ang - p->body->ang, 2*PI);
	char flip = 0;
	if (da < PI * 0.25 || da > PI*1.75) flip = 0;
	else if (da < PI * 0.75 ) flip = 1;
	else if (da < PI * 1.25) flip = 2;
	else flip = 3;
	if (xp < 0) {
		a += PI;
	}
	a = fmod(6 * PI + a - arclength, 2 * PI);
	int na = 0;
	for (int i = 1; i < 256; i++) {
		if (fabs(a - p->visionrays[i].ang) < fabs(a - p->visionrays[na].ang))
			na = i;
		else
			break;
	}
	int nb = 0;
	float cosval = cos(p->visionrays[na].ang - p->body->ang);
	float ah = fmod(a + arclength * 2, PI * 2);
	for (int i = 1; i < 256; i++) {
		if (fabs(ah - p->visionrays[i].ang) < fabs(ah - p->visionrays[nb].ang))
			nb = i;
		else
			break;
	}
	Rectangle src, dst;
	float val = e->size / (e->dist * cosval) * 3;
	src.y = (textures[0].height / 4) * flip;
	src.height = (textures[0].height / 4);
	src.width = 0;
	dst.y = height * 0.5 - height * val * e->size * 1.5;
	dst.width = skip;
	dst.height = height * val * 0.75;
	unsigned char colval = 255 * (1 - e->dist / 32);
	for (int i = na; (p->visionrays[i].ang < a + arclength * 2) && i <= 256; i = (i + 1)) {
		if (p->visionrays[i].ang > a) {

			if (e->dist < p->visionrays[i].dist) {
				src.x = (p->visionrays[i].ang - a)/(arclength*2)*textures[0].width*0.25 + (textures[0].width * 0.25 * ((e->frameoffset >> 2)%4));
				dst.x = p->visionrays[i].id * skip;
				DrawTexturePro(textures[0], src, dst, { 0,0 }, 0, {colval,colval,colval,255});
			}
		}
	}
	if (na > nb){
		for (int i = nb; i >= 0; i = (i - 1)) {
			if (p->visionrays[i].ang < p->visionrays[nb].ang) {
				if (e->dist < p->visionrays[i].dist) {
					src.x = fmod(2*PI+p->visionrays[i].ang - a,2*PI) / (arclength * 2) * textures[0].width * 0.25 + (textures[0].width * 0.25 * ((e->frameoffset >> 2) % 4));;
					dst.x = p->visionrays[i].id * skip;
					DrawTexturePro(textures[0], src, dst, { 0,0 }, 0, {colval,colval,colval,255});// used to use colval
				}
			}
		}
	}
}


void drawmaporcompassthing(Player* p, Image* map){
	if(p->maptoggle)
		DrawTriangle({ (float)(25 + cos(p->body->ang + PI * (float)0.5) * 8), (float)(25 + sin(p->body->ang + PI * (float)0.5) * 8) }, { (float)(25 + cos(p->body->ang) * 25), (float)(25 + sin(p->body->ang) * 25) }, { (float)(25 + cos(p->body->ang - PI * (float)0.5) * 8), (float)(25 + sin(p->body->ang - PI * (float)0.5) * 8) }, RED);
	else{
		
		for(int x=0;x<map->width; x++){
			for(int y=0;y<map->height; y++){
				Color t =  GetImageColor(*map, x,y);
				if(t.a != 0)
					DrawPixel(x,y, GetImageColor(*map, x,y));
			}
		}
		DrawRectangle(((int)p->body->pos.x), ((int)p->body->pos.y), 3,3,RED);
	}
}