#version 330

// Input vertex attributes (from vertex shader)
in vec2 fragTexCoord;
in vec4 fragColor;
// Output fragment color
out vec4 finalColor;

// NOTE: Add here your custom variables
uniform float nx1;
uniform float ny1;
uniform float nx2;
uniform float ny2;

uniform float fx1;
uniform float fy1;
uniform float fx2;
uniform float fy2;

uniform int flip;
uniform sampler2D texture0;


void main()
{
    float startx;
    float starty;
    float endx;
    float endy;
	if(flip != 0){
		startx = (fx1 - nx1) / (1. - fragTexCoord.y) + nx1;
		starty = (fy1 - ny1) / (1. - fragTexCoord.y) + ny1;
		endx = (fx2 - nx2) /   (1. - fragTexCoord.y) + nx2;
		endy = (fy2 - ny2) /   (1. - fragTexCoord.y) + ny2;
	}
    else{
		startx = (fx1 - nx1) / (fragTexCoord.y) + nx1;
		starty = (fy1 - ny1) / (fragTexCoord.y) + ny1;
		endx = (fx2 - nx2) /   (fragTexCoord.y) + nx2;
		endy = (fy2 - ny2) /   (fragTexCoord.y) + ny2;
    }
	float xsample = (endx - startx) * (fragTexCoord.x) + startx;
	float ysample = (endy - starty) * (fragTexCoord.x) + starty;
	//float nv = noise(vec2(xsample * 16., ysample * 16.))/2. + noise(vec2(xsample * 32., ysample * 32.))/4. + noise(vec2(xsample * 64., ysample * 64.))/8.;
	// vec4 texelColor = vec4(nv);
	// texelColor.g *=0.8;
	// texelColor.b *=0.8; 
	vec4 texelColor = texture(texture0, vec2(xsample, ysample));
	// NOTE: Implement here your fragment shader code

	finalColor = texelColor;
}