#include "VRay.h"
void VRay::draw() {
	DrawLine(start.x * 32, start.y * 32, xhit * 32, yhit * 32, {255,0,0,100});
	DrawCircle(xhit * 32, yhit * 32, 2, { 255,0,0,100 });
}
void VRay::cast(char** world, int w, int h, Vector2 _start, float _ang,  Image* map) {
	int iters = 0;
	start = _start;
	Vector2 pos = start;
	ang = fmod(2 * PI + fmod(_ang, 2 * PI), 2 * PI);
	float dx = 0, dy = 0;
	char xpositive = 1, ypositive = 1; // whether its traveling in the positive _ direction
	if (sin(ang) > 0) ypositive = 1;
	else ypositive = -1;
	if (cos(ang) > 0) xpositive = 1;
	else xpositive = -1;
	float xclosest, yclosest; // ok so like, xclosest is the dy value if you advanced to the next x gridline and yclosest is the x value if you advnaced to the next y gridline
	float tantheta = tan(ang), invtantheta = 1 / tantheta;
	hit = 0;
	while (iters < 64) {
		iters++;
		float fy = pos.y - floor(pos.y - 0.000001), fx = pos.x - floor(pos.x - 0.000001);
		if (xpositive > 0 && fx < 0.9999) fx = 1 - fx;
		if (ypositive > 0 && fy < 0.9999) fy = 1 - fy;
		xclosest = (fx * xpositive) * tantheta;
		yclosest = (fy * ypositive) * invtantheta;
		if (fy * fy + yclosest * yclosest > fx * fx + xclosest * xclosest) { // if you intersect the next x gridline before the next y gridline
			dx = fx * xpositive;
			dy = xclosest;
		}
		else {
			dx = yclosest;
			dy = fy * ypositive;
		}
		pos.x += dx;
		pos.y += dy;
		if((pos.x - start.x)*(pos.x - start.x) + (pos.y - start.y) * (pos.y - start.y) > 24*24){
			xhit = pos.x;
			yhit = pos.y;
			dist = 24;
			return;
		}
		hit = world[(int)(round(pos.x * 10000) * 0.0001 - 0.000001 * (xpositive < 0))][(int)(round(pos.y * 10000) * 0.0001 - 0.000001 * (ypositive < 0))];
		if(map!=nullptr){
			if(hit) ImageDrawPixel(map, ((int)pos.x), ((int)pos.y), GRAY);
			else ImageDrawPixel(map, ((int)pos.x), ((int)pos.y), WHITE);
		}
		if (hit != 0) {
			break;
		}
	}
	xhit = pos.x;
	yhit = pos.y;
	dist = sqrt((start.x - xhit) * (start.x - xhit) + (start.y - yhit) * (start.y - yhit)); // potential optimization by caching the trig functions
}

int VRayCompare(const void* p1, const void* p2)
{
	VRay a = *((VRay*)p1);
	VRay b = *((VRay*)p2);

	if (a.ang == b.ang) return 0;
	else if (a.ang < b.ang) return -1;
	else return 1;
}