//#include "raylib.h"
//#include <math.h>
#include <iostream>
#include "helper.h"
#define rtd(a) a * 57.29578
const int NUMTEXTS = 6;

int main() {
	Texture2D textures[NUMTEXTS], enttexs[1];
	const int WindowHeight = 960, WindowWidth = 1280;
	InitWindow(WindowWidth, WindowHeight, "hello window");
	srand(5);
	//using wfc to generate a tileset and map
	Image mapref = LoadImage("resources\\maptemplate.png");
	// RTileset *tileset = GenTileset(&mapref, 3);
	// Image worldmap = GenMap(200, 200, tileset, 1, 1);
	// delete tileset;
	Image worldmap = LoadImage("resources\\worldmap.png");
	ExportImage(worldmap, "worldmap.png");
	SetTargetFPS(30);
	World world(201,201);
	Image playermap = GenImageColor(world.width, world.height, {0,0,0,0});
	for (int i = 0; i < world.width; i++) {
		for (int j = 0; j < world.height; j++) {
			if (i == 0 || j == 0 || i == world.width - 1 || j == world.height - 1) {
				world.tiles[i][j] = 2;
				ImageDrawPixel(&playermap, i,j,GRAY);
			}
			else if (GetImageColor(worldmap, i - 1, j - 1).r == 0)
				world.tiles[i][j] = 1;
			else
				world.tiles[i][j] = 0;
		}
	}
	textures[0] = LoadTexture("resources\\fog.png");
	textures[1] = LoadTexture("resources\\bricks.png");
	textures[2] = LoadTexture("resources\\ancientbricks.png");
	textures[3] = LoadTexture("resources\\ground.png");
	textures[4] = LoadTexture("resources\\stars.png");
	textures[5] = LoadTexture("resources\\hand.png");
	enttexs[0] = LoadTexture("resources\\freak.png");
	Player player;

	player.body = &world.ents[0];
	int tx = 0, ty = 0;
	while (world.tiles[tx][ty]) {
		tx = rand() % world.width;
		ty = rand() % world.height;
	}
	player.body->pos.x = tx + 0.5;
	player.body->pos.y = ty + 0.5;
	player.body->vel.x = 0;
	player.body->vel.y = 0;
	player.body->ang = 0;
	
	for (int i = 1; i < world.numents; i++) {
		tx = 0;
		ty = 0;
		while (world.tiles[tx][ty]) {
			tx = rand() % world.width;
			ty = rand() % world.height;
		}
		world.ents[i].pos.x = tx + 0.5;
		world.ents[i].pos.y = ty + 0.5;
		world.ents[i].acc.x = 0;
		world.ents[i].acc.y = 0;
		world.ents[i].vel.x = 0;
		world.ents[i].vel.y = 0;
		world.ents[i].ang = 0;
	}
	tickplayer(&player, &world, &playermap);
	frustumshader shader = createfrustumshader();
	noiseshader nshader = createnoiseshader();
	float w=0;
	while (!WindowShouldClose()) {
		// logic
		checkcollisions(&world);
		tickentity(player.body, &world);
		tickplayer(&player,&world, &playermap);
		qsort(&world.ents[1], world.numents - 1, sizeof(Entity), &CompareEnts);
		for(int i=1;i<world.numents;i++){
			tickentity(&world.ents[i], &world);
		}

		// drawing
		BeginDrawing();
		ClearBackground(WHITE);
		drawview(&player, &world,WindowHeight, WindowWidth, textures, enttexs, shader, nshader);
		drawmaporcompassthing(&player, &playermap);
		//drawnoise(nshader, 0, 0, 4, 4, {0,0}, {0,0,125,125});
		w+=0.1;
		EndDrawing();
	}
	UnloadTexture(textures[0]);
	UnloadTexture(textures[1]);
	UnloadTexture(textures[2]);
	UnloadTexture(textures[3]);
	UnloadTexture(textures[4]);
	UnloadTexture(textures[5]);
	UnloadTexture(enttexs[0]);
	UnloadImage(mapref);
	UnloadImage(worldmap);
	UnloadImage(playermap);
	deletefrustumshader(shader);
	deletenoiseshader(nshader);
	CloseWindow();
}